DROP PROCEDURE [hips].[EpisodeLifecycleGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 22 November 2012
-- Description:   Gets a specific record from the EpisodeLifecycle Table
-- =============================================
CREATE PROCEDURE [hips].[EpisodeLifecycleGet] 
(
	@EpisodeLifecycleId INT = NULL
	,@DateModified DATETIME = NULL
)
AS
BEGIN
SELECT  s.EpisodeLifecycleId,
		s.Description,
		s.DateCreated,
		s.UserCreated,
		s.DateModified,
		s.UserModified
		
FROM  hips.EpisodeLifecycle s
WHERE (s.EpisodeLifecycleId = @EpisodeLifecycleId OR @EpisodeLifecycleId IS NULL)
AND (s.DateModified > @DateModified OR @DateModified IS NULL)
END
GO

